##### wv׋25 7񐶑ԉ́@R code #####

library(survival)

x <- c(2, 4, 4, 5, 7, 8, 10)		# 
cens0 <- c(1, 1, 1, 1, 1, 1, 1)		# censoring status: ł؂ԁi0Fł؂薳C1Fł؂Lj

Surv(x, cens0)

fit0 <- survfit(Surv(x, cens0) ~ 1)	# ֐Kaplan-Meierʂ߂

plot(fit0)						# Kaplan-Meier curve̕`iMԗLj
plot(fit0, conf.int=FALSE, xlab="time", ylab="Survival Function")		# Kaplan-Meier curve̕`iMԗLȂj



cens1 <- c(1, 1, 1, 1, 0, 1, 0)		# 7ځi5Ԗځj10ځi7Ԗځjɑł؂

Surv(x, cens1)

fit1 <- survfit(Surv(x, cens1) ~ 1)	# ֐Kaplan-Meierʂ߂
plot(fit1, conf.int=FALSE, xlab="time", ylab="Survival Function")



### a҂ɑ΂銰Ԃ̗Տr ###

library(MASS)

data(gehan)

fit.gehan <- survfit(Surv(time, cens) ~ treat, data=gehan)
plot(fit.gehan, mark.time=TRUE, col=c("blue", "red"))
legend(25,1,legend=c("6-MP", "control"), col=c("blue", "red"), lty=1, bty="n")

survdiff(Surv(time, cens) ~ treat, data=gehan)		# log-rank

survdiff(Surv(time, cens) ~ treat, data=gehan, rho=1)		# the Peto & Peto modification of the Gehan-Wilcoxon test

survdiff(Surv(time, status) ~ treat + strata(pair), data=gehan)		# stratified log-rank test


### NCCTG Lung Cancer Data ###
fit.lung <- survfit(Surv(time, status) ~ pat.karno, data=lung)
plot(fit.lung, col=rainbow(8), main="NCCTG Lung Cancer Data")
label <- names(table(lung$pat.karno))
legend(800, 1, legend=label, lty=rep(1,8), col=rainbow(8), bty="n")

survdiff(Surv(time, status) ~ pat.karno, data=lung)
survdiff(Surv(time, status) ~ pat.karno + strata(inst), data=lung)



### Cox proportional hazard model: a҂ɑ΂銰Ԃ̗Տr ###

fit.ph <- coxph(Surv(time, cens) ~ treat, data=gehan)
summary(fit.ph)

### complementary log-log plot: Gehan̔af[^ ###

plot(fit.gehan, fun="cloglog", ylab="Log(-Log(survival))", xlab="time", lty=1:2)
legend(2, 0.6, c("control", "6-MP"), lty=1:2)

### CoxnU[hfɂnU[h̉ɂẮASchoenfeld residualɂ錟 ###
cox.zph(fit.ph)



### ʉ@fɂ`f: ݋Rl̔xf[^ ###

fit <- coxph(Surv(time, status) ~ trt + karno + age, data=veteran)

cox.zph(fit)		# karno, agepl͏nU[h̔j]

library(mgcv)
fit.gam <- gam(time ~ trt + s(karno) + s(age), family=cox.ph(), weights=status, data=veteran)
summary(fit.gam)
plot(fit.gam)
